import { Link, useLocation } from 'react-router-dom'
import { ChefHat, Phone, Mail, MapPin } from 'lucide-react'
import './Layout.css'

const Layout = ({ children }) => {
  const location = useLocation()

  return (
    <div className="app">
      <header className="header">
        <div className="container">
          <div className="header-content">
            <div className="logo">
              <ChefHat className="logo-icon" size={36} />
              <span className="logo-text">КулинарМастер</span>
            </div>
            <nav className="nav">
              <Link to="/" className={`nav-link ${location.pathname === '/' ? 'active' : ''}`}>
                Мои участия
              </Link>
              <Link to="/book" className={`nav-link ${location.pathname === '/book' ? 'active' : ''}`}>
                Записаться
              </Link>
            </nav>
          </div>
        </div>
      </header>

      <main className="main">
        {children}
      </main>

      <footer className="footer">
        <div className="container">
          <div className="footer-content">
            <div className="footer-section">
              <div className="footer-logo">
                <ChefHat className="footer-logo-icon" size={32} />
                <h2>КулинарМастер</h2>
              </div>
              <p className="footer-description">Откройте для себя мир кулинарии вместе с нашими профессиональными шеф-поварами. Изучайте новые рецепты, техники и создавайте кулинарные шедевры.</p>
            </div>
            <div className="footer-section">
              <h3 className="footer-title">Темы мастер-классов</h3>
              <ul className="footer-links">
                <li><a href="/book">Выпечка</a></li>
                <li><a href="/book">Десерты</a></li>
                <li><a href="/book">Азиатская кухня</a></li>
                <li><a href="/book">Веганство</a></li>
              </ul>
            </div>
            <div className="footer-section">
              <h3 className="footer-title">Контакты</h3>
              <ul className="footer-links">
                <li>
                  <Phone className="contact-icon" size={18} />
                  <a href="tel:+79991234567">+7 (999) 123-45-67</a>
                </li>
                <li>
                  <Mail className="contact-icon" size={18} />
                  <a href="mailto:info@culinarymaster.ru">info@culinarymaster.ru</a>
                </li>
                <li>
                  <MapPin className="contact-icon" size={18} />
                  <span>Москва, ул. Кулинарная, 15</span>
                </li>
              </ul>
            </div>
          </div>
          <div className="footer-bottom">
            <p>&copy; 2024 КулинарМастер. Все права защищены.</p>
          </div>
        </div>
      </footer>
    </div>
  )
}

export default Layout

